import os
import re
import time
import paramiko
import subprocess
import datetime

Max_Exp = 300
CHIP_MAX: int = 106343

# Пути к файлам
path_to_srns2txt = '/home/vladimir/work/OryxGit/host/srns2txt'
file0x3 = '/tmp/new60_0x0003.txt'
log_file = 'log_enSpecialFix.txt'

# Мутим SSH до Oryx'a
host = '192.168.0.60'
user = 'root'
secret = 'plda'
port = 22
ssh_client = paramiko.SSHClient()
ssh_client.set_missing_host_key_policy(paramiko.AutoAddPolicy())

# Глобальные флаги
need_restart = True
curr_exp = 0
fail_count = 0
rage_counter = 0

# Регулярные выражения для парсинга 0x3 пакетика
TOW_regexp = re.compile(r'TOW=\s*(\d+)/\s*(\d+)\\\s*(\d+),')
EPOCH_regexp = re.compile(r'epoch=\s*(\d+)/([\d.]*)\\\s*(\d+),')
CHIP_regexp = re.compile(r'chip=\s*(\d+)\\\s*(\d+),')


def send_ssh_cmd(ssh_obj, cmd):
    status = False
    if ssh_obj.get_transport() is not None:
        status = ssh_obj.get_transport().is_active()

    try:
        if status is True:
            stdin, stdout, stderr = ssh_obj.exec_command(cmd)
            time.sleep(0.01)
        else:
            ssh_obj.connect(hostname=host, username=user, password=secret, port=port)
            time.sleep(0.01)
            stdin, stdout, stderr = ssh_obj.exec_command(cmd)
            time.sleep(0.01)
        ssh_obj.close()
    except Exception as e:
        error = "SSH exception,{}".format(e)
        print(error)


def write_log(filename, msg):
    with open(filename, 'a+') as fp:
        date = datetime.datetime.now()
        fp.write(date.strftime("%Y-%m-%d %H:%M") + ' ' + msg + '\n')


def check_pps_correction(str_to_parse):
    TOW_res = TOW_regexp.search(str_to_parse)
    if TOW_res:
        # TOW = int / int \ int
        TOWs = [int(x) for x in TOW_res.groups()]
        # print(TOWs)
    else:
        print('Error: No TOW match in string!')
        return False

    EPOCH_res = EPOCH_regexp.search(str_to_parse)
    if EPOCH_res:
        # epoch = int / ? float ? \ int
        EPOCHs = [int(EPOCH_res.group(1)), int(float(EPOCH_res.group(2))),
                  int(EPOCH_res.group(3))]
        # print(EPOCHs)
    else:
        print('Error: No EPOCH match in string!')
        return False

    CHIP_res = CHIP_regexp.search(str_to_parse)
    if CHIP_res:
        # chip = int \ int
        CHIPs = [int(x) for x in CHIP_res.groups()]
        # print(CHIPs)
    else:
        print('Error: No CHIP match in string!')
        return False

    # Проверка, что выставили шкалу по PPS и не упустили 1 мс.
    if (TOWs[0] == TOWs[2] and EPOCHs[2] == 0 and CHIPs[1] == 0) or \
            (TOWs[0] == (TOWs[2] + 1) and EPOCHs[2] == 999 and CHIPs[1] == CHIP_MAX):
        correct_msg = 'Correct PPSin time: TOW {:d}\\{:d}, EPOCH {:d}, CHIP {:d}'.format(TOWs[0], TOWs[2],
                                                                                   EPOCHs[2], CHIPs[1])
        write_log(log_file, correct_msg)
        print(correct_msg)
        return True
    else:
        err_msg = 'Wrong PPSin time: TOW {:d}\\{:d}, EPOCH {:d}, CHIP {:d}'.format(TOWs[0], TOWs[2],
                                                                               EPOCHs[2], CHIPs[1])
        write_log(log_file, err_msg)
        print(err_msg)
        return False


def find_string2parse(filename):
    ans_str = ''
    found_rcvTime_corr = False
    rcvTimeRegs_count = 0
    with open(filename, 'r', errors='ignore') as fp:
        for line in fp:
            if 'RcvTimeCorr' in line:
                found_rcvTime_corr = True
            if found_rcvTime_corr and ('RcvTimeRegs' in line):
                rcvTimeRegs_count += 1
                if rcvTimeRegs_count == 25:
                    ans_str = line
                    return ans_str
        return ans_str


# he he he
t = time.time()
while True:
    if curr_exp == Max_Exp:
        ssh_client.close()
        message = 'Finish -> failure rate = {:3.2f}% on {:d} experiments'.format(float(
            fail_count / curr_exp * 100.0), curr_exp)
        write_log(log_file, message)
        print(message)
        message = 'Elapsed time {:f} sec'.format(time.time()-t)
        write_log(log_file, message)
        print(message)
        break

    # Запуск парсера и ресивера по SSH
    if need_restart:
        print('Restart')
        send_ssh_cmd(ssh_client, '/etc/init.d/receiver stop')
        # print("1 - ")
        # print(stdout.read())
        # time.sleep(0.01)
        srns2txt = subprocess.Popen([path_to_srns2txt, '-t', host, '-o', '/tmp/new60'])
        time.sleep(0.01)
        send_ssh_cmd(ssh_client, '/etc/init.d/receiver start')
        # print("2 - ")
        # print(stdout.read())
        # time.sleep(0.01)

    print('Timeout start')
    time.sleep(60)  # Таймаут на коррекцию ШВП
    print('Timeout stop')

    # Читаем файл и проверяем коррекцию времени
    str2parse = find_string2parse(file0x3)
    if str2parse is not '':
        curr_exp += 1
        correct = check_pps_correction(str2parse)
        if not correct:
            fail_count += 1

        message = 'Current result -> failure rate = {:3.2f}% on {:d} experiments'.format(float(
            fail_count / curr_exp * 100.0), curr_exp)
        write_log(log_file, message)
        print(message)

        # Текущий эксперимент закончен, убиваем парсер и ресивер. Начинаем новую итерацию.
        srns2txt.kill()
        time.sleep(0.01)
        send_ssh_cmd(ssh_client, '/etc/init.d/receiver stop')
        need_restart = True
        rage_counter = 0
        # print("3 - ")
        # print(stdout.read())
        # time.sleep(0.01)
    else:   # Искомой строчки о коррекции пока нет в файле, надо бы еще почитать, по таймауту?
        if rage_counter < 2:
            need_restart = False
            rage_counter += 2
            os.system("cp /tmp/new60_0x0003.txt /tmp/firstFail.txt")
        else:
            rage_counter = 0
            need_restart = True
            message = '2 wrong iterations, restarting'
            write_log(log_file, message)
            print(message)
            srns2txt.kill()
            time.sleep(0.01)
            os.system("cp /tmp/new60_0x0003.txt /tmp/secondFail.txt")
            break
